import GetState from './GetState';
import IApi from '../api/IApi';
import ILogger from '../ILogger';
import DispatchType from './Dispatch';

interface IActionProps<Dispatch> {
    dispatch: Dispatch;
    getState: GetState;
    api: IApi;
    logger: ILogger;
    ApiError: Error;
}

type ThunkAction<Dispatch extends DispatchType = DispatchType, Result = any> = (
    props: IActionProps<Dispatch>,
) => void | Promise<Result>;

// eslint-disable-next-line no-undef
export default ThunkAction;
