import IApiStationRequest from './IApiStationRequest';
import IStationFromApi from '../state/station/IStationFromApi';
import IStationQuickFromApi from '../state/station/IStationQuickFromApi';
import IApiStationQuickRequest from './IApiStationQuickRequest';
import IApiTransferWithPrices from './IApiTransferWithPrices';
import IApiSearchTransfer2 from './IApiSearchTransfer2';
import IApiStationCityStationsRequest from './IApiStationCityStationsRequest';
import ICityData from '../state/station/ICityData';
import IApiStationPopularDirectionsRequest from './IApiStationPopularDirectionsRequest';
import IStationPopularDirectionsFromApi from '../state/station/IStationPopularDirectionsFromApi';
import IApiBugReportResponse from './IApiBugReportResponse';
import IApiBugReportRequest from './IApiBugReportRequest';
import IApiSeoMetaInfoParams from './IApiSeoMetaInfoParams';
import ApiSeoMetaInfoResponse from './ApiSeoMetaInfoResponse';
import IApiBusTariffsParams from './IApiBusTariffsParams';
import IApiBusTariffs from './IApiBusTariffs';
import Req from '../router/Req';
import IApiBlablacarCityLinkRequest from './IApiBlablacarCityLinkRequest';
import IApiBlablacarCityLinkResponse from './IApiBlablacarCityLinkResponse';
import IApiDirectionsRequest from './IApiDirectionsRequest';
import ApiDirectionsResponse from './ApiDirectionsResponse';
import IApiPopularDirectionsRequest from './IApiPopularDirectionsRequest';
import IStatePopularDirections from '../state/popularDirections/IStatePopularDirections';
import IApiStationPopularDirectionsRequest2 from './IApiStationPopularDirectionsRequest2';
import IApiStationsRequest from './IApiStationsRequest';
import IApiTeasersRequest from './IApiTeasersRequest';
import IApiStaticPageRequest from './IApiStaticPageRequest';
import IApiStaticPageResponse from './IApiStaticPageResponse';
import IApiSearchRequest from './IApiSearchRequest';
import IApiSearchResponse from './IApiSearchResponse';
import IApiParseContextRequest from './IApiParseContextRequest';
import IApiParseContextResponse from './IApiParseContextResponse';
import IApiCanonicalsRequest from './IApiCanonicalsRequest';
import IApiCanonicalsResponse from './IApiCanonicalsResponse';
import IApiSampleSearchContextRequest from './IApiSampleSearchContextRequest';
import IApiSampleSearchContextResponce from './IApiSampleSearchContextResponce';
import IApiStationStopsRequest from './IApiStationStopsRequest';
import IStationStopsFromBackend from '../state/station/IStationStopsFromBackend';
import IApiThreadParams from './IApiThreadParams';
import {IApiTrainTariffs2Response} from './IApiTrainTariffs2Response';
import {IApiTrainTariffs2Request} from './IApiTrainTariffs2Request';
import {IApiAllDaysTariffsRequest} from './IApiAllDaysTariffsRequest';
import {IApiAllDaysTariffsResponse} from './IApiAllDaysTariffsResponse';

// В ts-коде нужно использовать именно обертки для апи-методов,
// потому что иначе нормально типизировать метод exec не получается (overload не помогает).
export default interface IApi {
    // На уровне js в этом объекте есть метод exec: IApiLib, но он здесь не описан, дабы его не использовали в ts-коде
    execStation(
        params: IApiStationRequest,
        req?: Req,
    ): Promise<IStationFromApi>;
    execStationQuick(
        params: IApiStationQuickRequest,
        req?: Req,
    ): Promise<IStationQuickFromApi>;
    execStationCityStations(
        params: IApiStationCityStationsRequest,
        req?: Req,
    ): Promise<ICityData | undefined>;
    execStationPopularDirections(
        params: IApiStationPopularDirectionsRequest,
        req?: Req,
    ): Promise<IStationPopularDirectionsFromApi | undefined>;
    execStationPopularDirections2(
        params: IApiStationPopularDirectionsRequest2,
        req?: Req,
    ): Promise<IStationPopularDirectionsFromApi | undefined>;
    execStationStops(
        params: IApiStationStopsRequest,
        req?: Req,
    ): Promise<IStationStopsFromBackend>;
    execTransfersWithPrices(
        params: IApiTransferWithPrices,
        req?: Req,
    ): Promise<any>;
    execSearchTransfer2(params: IApiSearchTransfer2, req?: Req): Promise<any>;
    execBugReport(
        params: IApiBugReportRequest,
        req?: Req,
    ): Promise<IApiBugReportResponse>;
    execSeoMetaInfo(
        params: IApiSeoMetaInfoParams,
        req?: Req,
    ): Promise<ApiSeoMetaInfoResponse>;
    execBlablacarCityLink(
        params: IApiBlablacarCityLinkRequest,
        req?: Req,
    ): Promise<IApiBlablacarCityLinkResponse>;
    execDirections(
        params: IApiDirectionsRequest,
        req?: Req,
    ): Promise<ApiDirectionsResponse>;
    execPopularDirections(
        params: IApiPopularDirectionsRequest,
        req?: Req,
    ): Promise<IStatePopularDirections>;
    execStations(params: IApiStationsRequest, req?: Req): Promise<any>;
    execTeasers(params: IApiTeasersRequest, req?: Req): Promise<any>;
    // TODO: удалить после выкатки распов 18 мая 2022
    execBusTariffs(
        params: IApiBusTariffsParams,
        req?: Req,
    ): Promise<IApiBusTariffs>;
    execBusTariffs2(
        params: IApiBusTariffsParams,
        req?: Req,
    ): Promise<IApiBusTariffs>;
    execStaticPage(
        params: IApiStaticPageRequest,
        req?: Req,
    ): Promise<IApiStaticPageResponse>;
    execSearch(
        params: IApiSearchRequest,
        req?: Req,
    ): Promise<IApiSearchResponse>;
    execTimeCorrection(params: {}, req?: Req): Promise<number>;
    execParseContext(
        params: IApiParseContextRequest,
        req?: Req,
    ): Promise<IApiParseContextResponse>;
    execCanonicals(
        params: IApiCanonicalsRequest,
        req?: Req,
    ): Promise<IApiCanonicalsResponse | null>;
    execSampleSearchContext(
        params: IApiSampleSearchContextRequest,
        req?: Req,
    ): Promise<IApiSampleSearchContextResponce>;
    execTrainTariffs2(
        params: IApiTrainTariffs2Request,
        req?: Req,
    ): Promise<IApiTrainTariffs2Response>;
    execAllDaysTariffs(
        params: IApiAllDaysTariffsRequest,
        req?: Req,
    ): Promise<IApiAllDaysTariffsResponse>;
    execThread2(params: IApiThreadParams, req?: Req): Promise<unknown>;
}
