import {FilterTransportType} from '../../lib/transportType';
import DateSpecialValue from '../date/DateSpecialValue';
import NationalVersion from '../NationalVersion';
import Point from '../Point';
import CountryCode from '../state/transport/CountryCode';
import Slug from '../Slug';
import DateRobot from '../date/DateRobot';
import Lang from '../Lang';

interface IDirectionInfo {
    /** @example 'Москва' */
    title?: string;
    shortTitle?: string;
    popularTitle?: string;
    /** @example 'Москвы' */
    titleGenitive?: string;
    /** @example 'Москве' */
    titleLocative?: string;
    /** @example 'Москву' */
    titleAccusative?: string;
    /** Часто повторяющаяся модель, можно вынести на общий уровень и переиспользовать */
    settlement?: {
        slug: Slug;
        key: Point;
        title: string;
    };
    slug?: Slug;
    country?: {
        railwayTimezone: string;
        code: CountryCode;
        title: string;
    };
    region?: {
        title: string;
    };
    preposition?: string;
    key: Point;
    timezone?: string;
}

// Данный интерфейс НЕ ПОЛНОСТЬЮ описывает реальные данные
export default interface IApiSearchRequest {
    context: {
        transportType: FilterTransportType;
        from: IDirectionInfo;
        to: IDirectionInfo;
        when: {
            text?: string;
            hint?: string;
            formatted?: string;
            special?: DateSpecialValue;
            shortFormatted?: string;
            nextDate?: DateRobot;
            date?: DateRobot | DateSpecialValue;
        };
        language: Lang;
        searchNext?: boolean;
        plan?: string;
        time?: any;
    };
    isMobile?: boolean;
    groupTrains?: boolean;
    nationalVersion: NationalVersion;
    excludeTrains?: boolean;
    allowChangeContext?: boolean;
}
