import Lang from '../Lang';
import DateRobot from '../date/DateRobot';
import StationDateSpecialValue from '../date/StationDateSpecialValue';
import StationEventList from '../state/station/StationEventList';
import StationSubtype from '../state/station/StationSubtype';
import NationalVersion from '../NationalVersion';
import StationType from '../state/station/StationType';

export default interface IApiStationStopsRequest {
    stationId: number;
    language: Lang;

    date?: DateRobot | StationDateSpecialValue;
    event?: StationEventList;
    subtype?: StationSubtype;
    direction?: string;
    nationalVersion?: NationalVersion;
    returnForTypes?: StationType[]; // Список типов станций, для которых нужно вернуть список остановок. Если данная станция не соответствует ни одному из указанных типов, то ручка вернет пустой список остановок
}
