import Lang from '../Lang';
import NationalVersion from '../NationalVersion';
import EnvironmentType from '../EnvironmentType';
import IStateFlags from '../state/flags/IStateFlags';
import {FilterTransportType} from '../../lib/transportType';

export interface IApiTrainTariffs2Request {
    transportType: FilterTransportType.train | FilterTransportType.suburban;
    pointFrom: string;
    pointTo: string;
    now: number;
    language: Lang;
    nationalVersion: NationalVersion;
    flags: IStateFlags;
    startTime: string;
    endTime: string;

    poll?: boolean;
    environmentType?: EnvironmentType;
}
