import {Moment} from '../../../reexports/moment-timezone';
import {EventHandler, TouchEvent} from 'react';

import IStateFlags from '../state/flags/IStateFlags';
import ISearchSort from '../state/search/ISearchSort';
import ISearchContext from '../state/search/ISearchContext';

// Интерфейс данных, что отправляются в сегменты и пересадки в common/components/SearchSegments/SearchSegments
export default interface ISearchSegment<Segment> {
    data: {
        segment: Segment;
        sort: ISearchSort;
        context: ISearchContext;
        currentTimeMoment: Moment;
        isSuburbanSearchResult: boolean;
        isHidden: boolean; // Сегмент отфильтрован
        numberOfDirectSegments: number; // количество прямых рейсов в выдаче
        flags?: IStateFlags;
        showStops?: boolean;
        totalDuration?: string;
        position?: string;
        isStationsVisible?: boolean; // Необходимость отображения наименования станций для сегментов
        showArrivalDate?: boolean; // Необходимость отображения даты прибытия
        showDepartureDate?: boolean; // Необходимость отображения даты отправления
        showTransportIcon?: boolean;
        isSegmentOfInterline?: boolean;
    };

    onExpand?: EventHandler<TouchEvent>;
    isExpanded?: boolean;
    className?: string;
    withoutSegmentLabel?: boolean;
    withoutPrices?: boolean;
    withActionButton?: boolean;
}
