import DateRobot from '../../../interfaces/date/DateRobot';
import DateMoment from '../../../interfaces/date/DateMoment';
import ITerminal from '../../../interfaces/state/station/ITerminal';
import StationType from '../../../interfaces/state/station/StationType';
import AllThreadType from '../../../interfaces/state/station/AllThreadType';
import StationSubtype from '../../../interfaces/state/station/StationSubtype';
import StationEventList from '../../../interfaces/state/station/StationEventList';
import StationCompaniesById from '../../../interfaces/state/station/StationCompaniesById';
import AllStationInformerScheduleThreadType from './AllStationInformerScheduleThreadType';

// Только те поля из IStationFromApi, котоые нужны для показа информера
export default interface IInformerStationFromApi {
    id: number;
    type: StationType;
    title: string;
    threads: AllThreadType[] | AllStationInformerScheduleThreadType[]; // Массив может быть пустой!
    trusted: boolean; // true, если для станции доступны online статусы. Для расписания на все дни отсутствует
    companiesById: StationCompaniesById;
    terminals: ITerminal[]; // Массив может быть пустой!
    now: DateMoment; // Текущее время на станции в таймзоне станции
    event: StationEventList;

    fullTitle?: string;
    whenDate?: DateRobot;
    subtype?: StationSubtype;
}
