import {Moment} from 'moment';

import {TrainPartner} from '../../lib/order/trainPartners';
import ISegmentTariffs from './ISegmentTariffs';
import ISegmentTariffClass from './ISegmentTariffClass';
import ISegmentFromApi from './ISegmentFromApi';
import ISegmentBadges from './ISegmentBadges';
import ISegmentThread from './ISegmentThread';
import ISubSegment from './ISubSegment';
import SegmentCancelType from '../SegmentCancelType';

export default interface ISegment extends ISegmentFromApi {
    id: string; // Идентификатор, создаваемый на нашей стороне, для того, чтобы можно было менять состояние конкретного сегмента в редакс
    isGone: boolean;
    segmentId: string;
    timezoneFrom: string;
    timezoneTo: string;
    trainPartners: TrainPartner[];
    badges: ISegmentBadges;
    tariffsKeys: string[];
    tariffClassKeys: string[]; // На этапе рендеринга здесь будут ключи тарифов, которые нужно отображать
    isThroughTrain: boolean;
    isDynamic: boolean; // Признак того, что это рейс-пополнение. Т.е. данный сегмент пришел с тарифами.

    thread?: ISegmentThread;
    tariffs?: ISegmentTariffs<ISegmentTariffClass>;
    queryingPrices?: boolean;
    /** Тут лежат связанные сегменты (например сегменты на то же время но на другие дни) */
    subSegments?: ISubSegment[];
    departureMoment?: Moment; // Может быть доступно внутри некоторых компонентов, чьим родителем является common/components/SearchSegments/SearchSegments. Появляется при патчинге объекта в common/lib/segments/segmentRenderingData функцией getSegmentTimes из common/lib/segments/cachedSegmentTime
    arrivalMoment?: Moment; // Может быть доступно внутри некоторых компонентов, чьим родителем является common/components/SearchSegments/SearchSegments. Появляется при патчинге объекта в common/lib/segments/segmentRenderingData функцией getSegmentTimes из common/lib/segments/cachedSegmentTime
    departureRailwayMoment?: Moment | null; // Может быть доступно внутри некоторых компонентов, чьим родителем является common/components/SearchSegments/SearchSegments. Появляется при патчинге объекта в common/lib/segments/segmentRenderingData функцией getSegmentTimes из common/lib/segments/cachedSegmentTime
    arrivalRailwayMoment?: Moment | null; // Может быть доступно внутри некоторых компонентов, чьим родителем является common/components/SearchSegments/SearchSegments. Появляется при патчинге объекта в common/lib/segments/segmentRenderingData функцией getSegmentTimes из common/lib/segments/cachedSegmentTime
    codesharesIsOpened?: boolean; // Признак того, что список кодшеров сегмента открыт
    missedTariffs?: string[]; // Содержит id тарифов Яндекс.Автобусов (ISegmentFromBackend['yBusId']), которые не были склеены с сегментом, из-за того, что соответствовали более чем одному сегменту
    cancelType?: SegmentCancelType | null; // null, если сегмент не отменен. Появляется при патчинге сегментов в common/lib/segments/patchSegments.ts
}
