import ISegmentFromBackend from './ISegmentFromBackend';
import ISubSegmentFromApi from './ISubSegmentFromApi';

export default interface ISegmentFromApi extends ISegmentFromBackend {
    isMetaSegment: boolean;

    isMerged?: boolean; // признак того, что сегмент был смержен с другим сегментом вот здесь: common/lib/segments/mergeSegments.js
    useCityInsteadStationTo?: boolean; // Встречается в автобусных тарифах. Означает, что вместо стнации прибытия нужно показывать город прибытия
    useCityInsteadStationFrom?: boolean; // Встречается в автобусных тарифах. Означает, что вместо стнации отправления нужно показывать город отправления
    subSegments?: ISubSegmentFromApi[];
    isArchival?: boolean; // Признак того, что рейс раньше ходил, а теперь нет, но мы все равно его хотим отображать, только без некоторых данных, например цен и кнопок покупки.
    hasVariants?: boolean; // Для автобусов. Признак того, что для данного автобуса можно приобрести билет через разных партнеров
    ambiguous?: boolean; // Означает, что данный тариф (если это тариф) соответствует более чем одному сегменту
}
