import ISegmentCompany from './ISegmentCompany';
import ISegmentStation from './ISegmentStation';
import ISegmentThread from './ISegmentThread';
import ISegmentTransport from './ISegmentTransport';
import ISegmentTariffs from './ISegmentTariffs';
import ISegmentTariffClassFromBackend from './ISegmentTariffClassFromBackend';
import ISubSegmentFromBackend from './ISubSegmentFromBackend';
import ISegmentEvent from './ISegmentEvent';
import ISegmentFacility from './ISegmentFacility';
import ISegmentDaysByTimezone from './ISegmentDaysByTimezone';
import IMaskDaysOfWalking from '../maskDaysOfWalking/IMaskDaysOfWalking';
import DateRobot from '../date/DateRobot';
import ISegmentCodeshare from './ISegmentCodeshare';
import DateMoment from '../date/DateMoment';

export default interface ISegmentFromBackend {
    title: string;
    arrival: DateMoment;
    arrivalEvent: ISegmentEvent | null;
    arrivalEventKey: string | null;
    departure: DateMoment;
    departureEvent: ISegmentEvent | null;
    departureEventKey: string | null;
    duration: number; // Продолжительность поездки в секундах
    company: ISegmentCompany | null; // null часто встречается у автобусных сегментов, когда нет данных о перевозчике
    isInterval: boolean;
    isThroughTrain: boolean | null;
    number: string;
    stationFrom: ISegmentStation;
    stationTo: ISegmentStation;
    transport: ISegmentTransport;
    suburbanFacilities: ISegmentFacility[] | null;
    arrivalLocalDt: DateMoment; // Время прибытия в таймзоне пункта прибытия
    departureLocalDt: DateMoment; // Время отправления в таймзоне пункта отправления

    thread?: ISegmentThread | null;
    tariffs?: ISegmentTariffs<ISegmentTariffClassFromBackend>;
    tariffsKeys?: string[];
    key?: string;
    keys?: string[];
    stops?: string; // информация об остановках. Например "кроме: Фрязино-Тов."
    source?: string; // возможно такое свойство есть у автобусных сегментов
    ufsTitle?: string;
    twoStorey?: boolean;
    rawTrainCategory?: string;
    hasDynamicPricing?: boolean; // приходит с тарифами поездов
    isSuburban?: boolean;
    originalNumber?: string;
    rawTrainName?: null | string;
    hasTrainTariffs?: boolean | null;
    startDate?: string;
    maxArrival?: string; // минимальное время прибытия. Есть у мета-сегментов
    minArrival?: string; // максимальное время прибытия. Есть у мета-сегментов
    subSegments?: ISubSegmentFromBackend[]; // сегменты мета-сегмента
    canSupplySegments?: boolean /* означает, что данные сегмента с тарифом можно использовать
    как рейс-пополнение (т.е. добавить в выдачу, как самостоятельный сегмент) */;
    companies?: ISegmentCompany[]; // информация о компаниях для мета-сегментов
    url?: string; // ссылка на нитку у самолетных сегментов
    isFuzzyFrom?: boolean; // признак, того, что время отправления не точное
    isFuzzyTo?: boolean; // признак, того, что время прибытия не точное
    daysByTimezone?: ISegmentDaysByTimezone; // Тексты, опсывающие дни хождения для поиска на все дни
    runDays?: IMaskDaysOfWalking; // Макса дней хождения для поиска на все дни
    canPayOffline?: boolean; // Встречается в автобусных тарифах
    yBusId?: string; // Встречается в автобусных тарифах
    intervalThreadDepartureFromDate?: DateRobot; // Дата старта нитки для интервальных рейсов. Нужна для того, чтобы строить корректные ссылки на страницу нитки со страницы поиска
    codeshares?: ISegmentCodeshare[]; // Список кодшерных рейсов, которые летят на донном борту
    trainPurchaseNumbers?: string[]; // Для сегмента электричек ЦППК, которые являются одновременно и поездами, номера поездовых ниток.
    salesLimitInDays?: number; // За сколько дней открывается продажа билетов на поезда. Бывает для поездов на выдаче на все дни.
}
