import StationSubtype from '../state/station/StationSubtype';
import StationType from '../state/station/StationType';

export default interface ISegmentStation {
    id: number;
    country: {
        code: string; // 'RU'
        id: number; // 225
    } | null;
    popularTitle: string; // 'Крымская'
    settlementId: number; // 10997
    timezone: string; // 'Europe/Moscow'
    title: string; // 'Крымская'

    railwayTimezone?: string; // 'Europe/Moscow'
    platform?: string;
    ufsTitle?: string | null;
    codes?: {
        express?: string; // '2064320'
    };
    idFromSearchApi?: number; // значение id, пришедшее из ручки search, в случае, если партнер автобусов вернул в качестве id данные города или несовпадающей с нашей станции.
    pageType?: StationType; // 'train'. Это свойство есть в ответе ручки search, но его может не быть в сегментах тарифов
    mainSubtype?: StationSubtype; // 'train'
}
