import ICancelledSegment from './ICancelledSegment';

export default interface ISegmentThreadBase {
    uid: string;
    title: string;
    beginTime: string | null; // Время начала движения для интервальных рейсов. Например "07:00:00"
    endTime: string | null; // Время завершения движения для интервальных рейсов. Например "22:00:00"
    comment: string; // Комментарий перевозчика
    density: string; // Есть в интервальных рейсах. Пример: "маршрутное такси раз в 10-20 минут"
    displaceYabus: null | true; // Признак того что к данному сегменту можно клеить цены от Яндекс Автобусов
    isExpress: boolean;
    isAeroExpress: boolean;
    isBasic: boolean; // Не используется в текущем коде
    number: string;
    schedulePlanCode: null | string;
    deluxeTrain?: {
        id: number;
        title: string;
        shortTitle: string;
        pagePath: string;
        isDeluxe: boolean;
        isHightSpeed: boolean;
    };
    canonicalUid?: string;
    /* Названия станций, на участке между которыми есть отмена. Приходит только если присутствует свойство cancelled */
    cancelledSegments?: ICancelledSegment[];
    /* Признак, что на данном сегменте есть отмена. true, если отменён полностью; - false, если отменён не полностью; отсутствует, если отмен нет. */
    cancelled?: boolean;
}
