import {Moment} from 'moment';

import ISegmentTariffs from './ISegmentTariffs';
import ISubSegmentFromApi from './ISubSegmentFromApi';
import ISegmentTariffClass from './ISegmentTariffClass';

export default interface ISubSegment extends ISubSegmentFromApi {
    timezoneFrom: string;
    timezoneTo: string;

    tariffs?: ISegmentTariffs<ISegmentTariffClass>; // Присутствует у поездов на все дни

    departureMoment?: Moment; // Может быть доступно внутри некоторых компонентов, чьим родителем является common/components/SearchSegments/SearchSegments. Появляется при патчинге объекта в common/lib/segments/segmentRenderingData функцией getSegmentTimes из common/lib/segments/cachedSegmentTime
    arrivalMoment?: Moment; // Может быть доступно внутри некоторых компонентов, чьим родителем является common/components/SearchSegments/SearchSegments. Появляется при патчинге объекта в common/lib/segments/segmentRenderingData функцией getSegmentTimes из common/lib/segments/cachedSegmentTime
    departureRailwayMoment?: Moment | null; // Может быть доступно внутри некоторых компонентов, чьим родителем является common/components/SearchSegments/SearchSegments. Появляется при патчинге объекта в common/lib/segments/segmentRenderingData функцией getSegmentTimes из common/lib/segments/cachedSegmentTime
    arrivalRailwayMoment?: Moment | null; // Может быть доступно внутри некоторых компонентов, чьим родителем является common/components/SearchSegments/SearchSegments. Появляется при патчинге объекта в common/lib/segments/segmentRenderingData функцией getSegmentTimes из common/lib/segments/cachedSegmentTime
}
