import ISegmentCompany from './ISegmentCompany';
import ISegmentStation from './ISegmentStation';
import ISegmentThread from './ISegmentThread';
import ISegmentTransport from './ISegmentTransport';
import DateMoment from '../date/DateMoment';

export default interface ISubSegmentFromBackend {
    title: string;
    transport: ISegmentTransport;
    company: ISegmentCompany;
    arrival: DateMoment;
    arrivalEvent: string | null;
    arrivalEventKey: string | null;
    departure: DateMoment;
    departureEvent: string | null;
    departureEventKey: string | null;
    duration: number;
    isInterval: false;
    isThroughTrain: boolean;
    number: string;
    startDate: string;
    stationFrom: ISegmentStation;
    stationTo: ISegmentStation;
    stops: string;
    suburbanFacilities: null;
    thread: ISegmentThread | null;
    arrivalLocalDt: DateMoment; // Время прибытия в таймзоне пункта прибытия
    departureLocalDt: DateMoment; // Время отправления в таймзоне пункта отправления

    isFuzzyFrom?: boolean; // признак, того, что время отправления не точное
    isFuzzyTo?: boolean; // признак, того, что время прибытия не точное
}
