import IStateFlags from './flags/IStateFlags';
import IStateSearchForm from './IStateSearchForm';
import Tld from '../Tld';
import IStateCurrencies from './IStateCurrencies';
import IStateSearch from './search/IStateSearch';
import IStateEnvironment from './IStateEnvironment';
import Platform from '../Platform';
import IStatePage from './IStatePage';
import Lang from '../Lang';
import IStateSeoQueryParams from './IStateSeoQueryParams';
import IStateUser from './user/IStateUser';
import IStateDirections from './directions/IStateDirections';
import ISettlement from './settlement/ISettlement';
import IStateStation from './station/IStateStation';
import IStateBugReporter from './bugReporter/IStateBugReporter';
import NationalVersion from '../NationalVersion';
import IStatePopularDirections from './popularDirections/IStatePopularDirections';
import IStateHome from './IStateHome';
import IStationGroup from './stationsGroup/IStationGroup';
import IStateInfo from './info/IStateInfo';
import IStateSearchCalendar from './IStateSearchCalendar';
import IStateSearchFormHints from './IStateSearchFormHints';
import IStateThread from './stateThread/IStateThread';
import IStateSuggests from './IStateSuggests';

/** Redux-state приложения */
export default interface IState {
    tld: Tld;
    nonce: string;
    nationalVersion: NationalVersion;
    language: Lang;
    flags: IStateFlags;
    isTouch: boolean; // Признак того, что мы находимся на тачевом домене, типа t.rasp.yandex.ru
    searchForm: IStateSearchForm;
    searchFormHints: IStateSearchFormHints; // Данные для направлений под поисковой формой (состоят из истории поиска пользователя и популярного направления для данного города)
    searchCalendar: IStateSearchCalendar;
    currencies: IStateCurrencies;
    search: IStateSearch;
    station: IStateStation;
    environment: IStateEnvironment;
    platform: Platform;
    stationsGroup: IStationGroup[];
    page: IStatePage;
    generatedInputName: string; // Уникальная строка, которая добавляется к name инпутов, чтобы не работало браузерное автодополнение
    seoQueryParams: IStateSeoQueryParams;
    user: IStateUser;
    directions: IStateDirections;
    popularDirections: IStatePopularDirections;
    clientSettlement: ISettlement; // Данные о населенном пункте из запроса (где действительно находится пользователь)
    currentSettlement: ISettlement; // Данные о выбранном населенном пункте (можно выбрать на главной)
    bugReporter: IStateBugReporter;
    home: IStateHome;
    info: IStateInfo;
    thread: IStateThread;
    suggests: IStateSuggests;
}
