import {FilterTransportType} from '../../lib/transportType';
import Lang from '../Lang';
import Tld from '../Tld';
import ITime from './searchForm/ITime';
import IWhen from './IWhen';
import ISearchFormError from './searchForm/ISearchFormError';

export default interface IStateSearchForm {
    transportType: FilterTransportType;
    from: object;
    originalFrom: object;
    to: object;
    originalTo: object;
    when: IWhen;
    searchNext: boolean;
    errors: ISearchFormError[];
    time: ITime;
    userInput: {
        from: object;
        to: object;
    };
    defaultTimezone: string;
    language: Lang;
    tld: Tld;
    distance: number | null;
    sameSuburbanZone: boolean;
    plan: null | object;
}
