import Point from '../../Point';
import Slug from '../../../interfaces/Slug';
import {FilterTransportType} from '../../../lib/transportType';

export default interface IPopularDirectionPoint {
    directionTitle: string; // "из Железнодорожного"
    title: string; // "Железнодорожный"
    id: number; // 21622
    key: Point; // "c21622"
    slug: Slug; // "zheleznodorozhny"

    transportType?: FilterTransportType; // Тип транспорта, если поиск сужается до одного типа. Если по-прежнему нужно формировать ссылку на поиск всеми типами транспорта, то поле transportType отсутствует
    innerSlug?: Slug; // Слаг города, на странице которого мы находимся, или станции, до которой его сузили. Не имеет отношения к городу/станции точки. Это слаг города_на_странице_которого_находимся в направлении: "город_на_странице_которого_находимся" - "точка" (или он же в обратном направлении).
}
