import IWhen from '../IWhen';
import Lang from '../../../interfaces/Lang';
import {FilterTransportType, TransportType} from '../../../lib/transportType';
import ISearchCanonical from './ISearchCanonical';
import IUserInputPoint from '../searchForm/IUserInputPoint';
import IPoint from '../searchForm/IPoint';
import DateMoment from '../../date/DateMoment';

export default interface ISearchContext {
    userInput: {
        from: IUserInputPoint;
        to: IUserInputPoint;
    };
    from: IPoint;
    originalFrom: IPoint;
    to: IPoint;
    originalTo: IPoint;
    searchNext: boolean;
    when: IWhen;
    time: {
        now: number;
        timezone: string;
    };
    language: Lang;
    searchForPastDate: boolean;
    sameSuburbanZone: boolean;
    transportType: FilterTransportType;
    transportTypes: TransportType[];
    latestDatetime: DateMoment; // '2020-12-10T00:00:00+00:00' - время отправления последнего сегмента в выдаче
    canonical: ISearchCanonical | null;

    distance?: number;
    original?: {pointFrom: IPoint; pointTo: IPoint};
    isChanged?: boolean;
}
