import ISearchSort from './ISearchSort';
import ISearchContext from './ISearchContext';
import ISearchFiltering from './ISearchFiltering';
import SearchSegment from './SearchSegment';
import ISearchQuerying from './ISearchQuerying';
import IBlablacar from '../blablacar/IBlablacar';
import {TransportType} from '../../../lib/transportType';
import IApiSeoMetaInfo from '../../api/IApiSeoMetaInfo';
import TeasersRecord from '../teasers/TeasersRecord';
import ISearchArchivalData from './ISearchArchivalData';
import {ISearchPopularDirectionLink} from './ISearchPopularDirectionLink';
import ICanonicalFromBackend from '../../../interfaces/api/ICanonicalFromBackend';
import {TBannerInfo} from './BannerInfo';

export default interface IStateSearch {
    sort: ISearchSort;
    context: ISearchContext;
    segments: SearchSegment[];
    vector: [];
    queryingPrices: boolean;
    pricesAreCached: boolean;
    querying: ISearchQuerying;
    filtering: ISearchFiltering;
    plans: object;
    sortMapping: {
        vector: [];

        segments?: SearchSegment[];
        filteredSegmentIndices?: boolean[];
    };
    trainPartners: [];
    transportTypes: TransportType[];
    isSuburbanSearchResult: boolean;
    isBusSearchResult: boolean;
    isLastochkaPage: boolean;
    stats: {
        hasElectronicTicket: boolean;
        hasDynamicPricing: boolean;
    };
    blablacar: IBlablacar;
    teasers: TeasersRecord;
    canonicals: ICanonicalFromBackend[] | null; // данные для отрисовки блока со ссылками на другие виды транспорта на мобильной странице поиска
    popularDirectionsLinks: ISearchPopularDirectionLink[];

    seoMetaInfo?: IApiSeoMetaInfo;
    archivalData?: ISearchArchivalData; // объект с информацией о том что рейсы ходили, но сейчас временно отменены

    bannerInfo?: TBannerInfo;
}
