import {TransportType} from '../../../lib/transportType';
import IThreadPageSegment from './IThreadPageSegment';
import IStation from '../thread/IStation';
import ICapital from '../../../interfaces/ICapital';
import DateMoment from 'common/interfaces/date/DateMoment';
import IBlablacar from '../blablacar/IBlablacar';

/* Интерфейс описан не полностью, постепенно пополняется */
export default interface IStateThread {
    segment: IThreadPageSegment;
    transportType: TransportType;
    priceQuerying: boolean;
    id: string;
    canonicalUid: string;
    runDaysText: string;
    prevStationsIsOpened: boolean;
    nextStationsIsOpened: boolean;
    isIntervalThread: boolean;
    isSuburbanBus: boolean;
    beginTime: string;
    endTime: string;
    density: string;
    comment: string;
    capitalSlug: string;
    capitals: ICapital[];
    fromStationDepartureLocalDt: DateMoment;
    /* Признак экспресса по аналогии с ручками search и station. Присутствует в ответе всегда */
    isExpress: boolean;
    /* Признак аэроэкспресса по аналогии с ручками search и station. Присутствует в ответе всегда */
    isAeroExpress: boolean;
    blablacar: IBlablacar;

    shortTitle?: string;
    stationFrom?: string;
    stationTo?: string;
    stations?: IStation[];
    departure?: string;
    departureFrom?: string;
    currentTimezone?: string;
}
