import IStationFromApi from './IStationFromApi';
import ICityData from './ICityData';
import IStationPopularDirectionsFromApi from './IStationPopularDirectionsFromApi';
import ITeaser from '../teasers/ITeaser';
import StationTime from './StationTime';
import StationCompaniesById from './StationCompaniesById';
import IStationStop from './IStationStop';
import IStationStopFilter from './IStationStopFilter';

export default interface IStateStation extends IStationFromApi {
    calendarIsOpened: boolean;
    goneThreadsAreOpened: boolean;
    moreDirectionsIsOpened: boolean; // Признак отрытия/закрытия попапа с направлениями электричек, которые не влезли в строку направлений
    teasers: ITeaser[];
    companiesById: StationCompaniesById;
    terminalName: string; // Имя текущего выбранного терминала
    search: string; // Контент инпута поиска ниток
    stops: IStationStop[]; // Массив может быть пустой!
    stopText: string; // Текст инпута фильтра по станции
    stop: IStationStopFilter | null; // Фильтр по остановке
    stationFilterIsOpened: boolean; // Признак того, что открыты саджесты для фильтра по станции

    cityData?: ICityData;
    popularDirections?: IStationPopularDirectionsFromApi;
    time?: StationTime; // Фильтр по времени
}
