import StationType from './StationType';
import StationSubtype from './StationSubtype';
import StationEventList from './StationEventList';
import DateRobot from '../../date/DateRobot';
import IStationWayToAirport from './IStationWayToAirport';
import StationDateSpecialValue from '../../date/StationDateSpecialValue';
import ITeaserFromApi from '../teasers/ITeaserFromApi';
import IDirection from './IDirection';
import IStationSettlement from './IStationSettlement';
import IStationCompany from './IStationCompany';
import ITerminal from './ITerminal';
import DateMoment from '../../date/DateMoment';
import AllThreadType from './AllThreadType';
import IStationScheduleBlock from './IStationScheduleBlock';

export default interface IStationFromApi {
    id: number;
    type: StationType;
    subtypes: StationSubtype[]; // Массив может быть пустой!
    pointType: string; // Тип станции: порт, остановка, автовокзал и тд. на запрошенном языке
    title: string; // 'Павелецкий вокзал' - может включать тип станции и город.
    hasPopularTitle: boolean; // Есть ли популярное название. Если есть, то оно используется в полях типа title и fullTitle, иначе - официальное название
    event: StationEventList; // 'departure'
    threads: AllThreadType[]; // Массив может быть пустой!
    teasers: ITeaserFromApi[]; // Массив может быть пустой!
    trusted: boolean; // true, если для станции доступны online статусы. Для расписания на все дни отсутствует
    companies: IStationCompany[]; // Массив может быть пустой!
    terminals: ITerminal[]; // Массив может быть пустой!
    now: DateMoment; // Текущее время на станции в таймзоне станции
    scheduleBlocks: IStationScheduleBlock[]; // Массив может быть пустой!

    latitude?: number; // 55.729498
    longitude?: number; // 37.640771
    directions?: IDirection[]; // [{ key: 'на Москву', text: 'на Москву }]
    directionCode?: string; // 'от Москвы'
    mainSubtype?: StationSubtype;
    currentSubtype?: StationSubtype;
    subway?: string; // 'м. Павелецкая'
    address?: string; // 'Москва, Павелецкая пл., 1'
    settlement?: IStationSettlement;
    titleGenitive?: string; // 'Павелецкого вокзала' - может включать тип станции и город.
    fullTitle?: string; // 'вокзал Екатеринбург-Пасс.' - включает тип станции и может быть город.
    fullTitleDative?: string; // 'вокзалу Екатеринбург-Пасс.' - включает тип станции и может быть город.
    fullTitleGenitive?: string; // 'вокзала Екатеринбург-Пасс.' - включает тип станции и может быть город.
    whenDate?: DateRobot;
    whenSpecial?: StationDateSpecialValue;
    wayToAirport?: IStationWayToAirport;
    dtAfter?: DateMoment; // '2020-03-11T08:00:00+03:00'. Нижняя граница временного диапазона в таймзоне станции
    dtBefore?: DateMoment; // '2020-03-11T12:00:00+03:00'. Верхняя граница временного диапазона в таймзоне станции
    iataCode?: string; // 'SVO' - IATA-код аэропорта
    phones?: string[]; // Телефоны станции. Каждый элемент масиива может содержать несколько телефонов перечисленных через запятую
    notEnoughInfo?: boolean; // Недостаточно информации для отображения списка рейсов
}
