import IStationTypeFromBackend from './IStationTypeFromBackend';
import IStationThreadFromBackend from './IStationThreadFromBackend';
import IStationCompanyFromBackend from './IStationCompanyFromBackend';
import IStationScheduleBlock from './IStationScheduleBlock';

interface IDirectionFromBackend {
    code: string;
    title: string;
}

interface ITeaserFromBackend {
    title: string;
    content: string;
    mobileContent: string | null;

    importance?: number;
    id?: number;
    imageUrl?: string | null;
    image_url?: string | null;
    url?: string;
}

export default interface IStationFromBackend {
    pageType: IStationTypeFromBackend;
    station: {
        id: number; // 200
        stationType: string; // 'вокзал'
        title: string; // 'Павелецкий вокзал'
        hasPopularTitle: boolean;
        titleGenitive: string | null; // 'Павелецкого вокзала'
        fullTitle: string | null; // 'вокзал Екатеринбург-Пасс.'
        fullTitleDative: string | null; // 'вокзалу Екатеринбург-Пасс.'
        fullTitleGenitive: string | null; // 'вокзала Екатеринбург-Пасс.'
        subway: string | null; // 'м. Павелецкая'
        address: string | null; // 'Москва, Павелецкая пл., 1'
        longitude: number | null; // 37.640771
        latitude: number | null; // 55.729498
        wayToAirport: {
            toPointId: string; // 's9600216'
            fromPointId: string; // 's2000005'
            fromSlug: string; // 'moscow-paveletskaya'
            toSlug: string; // 'domodedovo-airport'
            linkTitle: string; // 'Аэроэкспресс в Домодедово'
            wayType: 'aeroexpress' | null;
        } | null;

        directions?: IDirectionFromBackend[]; // Список направлений для элетричек: [{ code: 'на Москву', title: 'на Москву }]
        settlement?: {
            id: number;
            slug: string;
            title: string;
            titleGenitive: string | null;
        };
        trusted?: boolean; // true, если для станции доступны online статусы. Для расписания на все дни отсутствует
        iataCode?: string; // 'SVO' - IATA-код аэропорта
        phones?: string[]; // ['+7 (3919) 42-82-66, +7 (3919) 43-73-73', '+7 (3919) 42-00-06'] - Телефоны станций.
    };
    context: {
        when: {
            special?: 'today' | 'tomorrow' | 'all-days'; // Отсутствует для поиска на все дни, или при поиске на конкретную дату
            date?: string; // '2019-12-30'. Отсутствует для поиска на все дни
            dtAfter?: string; // '2020-03-11T08:00:00+03:00'. Нижняя граница временного диапазона в таймзоне станции
            dtBefore?: string; // '2020-03-11T12:00:00+03:00'. Верхняя граница временного диапазона в таймзоне станции
        };
        event: 'departure' | 'arrival';
        directionCode?: string; // 'от Москвы'
        dtNow: string; // '2020-03-11T10:11:12+03:00'. Текущее время в таймзоне станции
    };
    teasers: Record<string, ITeaserFromBackend>;

    threads?: IStationThreadFromBackend[]; // Есть для ЖД-станций и аэропортов. Массив может быть пустой!
    companies?: IStationCompanyFromBackend[]; // Есть для аэропортов и атобусных станций
    scheduleBlocks?: IStationScheduleBlock[]; // Есть для автобусных станций. Сгруппированные по маршрутам блоки с нитками, сгруппированными по дням хождения.
}
