import AllScheduleThreadType from './AllScheduleThreadType';

// Описывает блок ниток рейса, сгруппированных по дням хождения
// Для расписания станции на дату будет только один такой блок ниток для рейса
export default interface IStationSchedule {
    threads: AllScheduleThreadType[];

    daysText?: string; // Полная строка с днями хождения, может отсутствовать, если указаны runDaysText
    runDaysText?: string; // Строка дней, когда нитка точно ходит, имеет приоритет над daysText
    exceptDaysText?: string; // Строка исключения дней хождения. Работает вместе с runDaysText. Может отсутствовать, если нет исключаемых дней или используется daysText. Слово "кроме" в строку не включено.
}
