import {TransportType} from '../../../lib/transportType';
import IStationSchedule from './IStationSchedule';

// Описывает блок рейса автобусной станции
// Для расписания станции на все дни в нем могут быть несколько блоков с нитками, сгруппированными по дням хождения
export default interface IStationScheduleBlock {
    title: string; // "Москва (м. Медведково) — Тарасовка (МГУ Сервиса)"
    number: string; // "531"
    comment: string; // Поле из БД. Например здесь указывается комментарий к интервальным рейсам "по заполнению"
    companyId: number; // id компании-перевозчика
    transportType: TransportType; // На практике тут бедет "bus" или "water", но в теории нам ничто не мешает отобразить таким образом любой вид транспорта
    schedule: IStationSchedule[]; // Блоки с нитками, сгруппированными по дням хождения для расписания на все дни. Для расписания на дату будет только один блок
}
