import IRouteStation from './IRouteStation';
import ICodeshare from './ICodeshare';

export default interface IStationThreadFromBackend {
    eventDt: {
        time: string; // 17:52
        datetime?: string; // 2020-01-24T17:52:00+05:00
    };
    number: string;
    title: string;
    transportType: string;
    canonicalUid: string;
    isAeroExpress: boolean;
    isExpress: boolean;

    stops?: {
        // есть только у электричек
        type: 'stops' | 'nonstop' | 'everywhere';
        text?: string;
    };
    departure?: string;
    departureFrom?: string;
    transportSubtype?: {
        code: string; // может принимать значения 'suburban', 'last', 'lastdal' и ещё десятки каких-то других
        title: string;
    };
    deluxeTrainTitle?: string;
    platform?: string;
    daysText?: string;
    exceptDaysText?: string;
    runDaysText?: string;
    companyId?: number; // id компании-перевозчика
    terminal?: string; // 'B' - название терминала по расписанию
    aviaLink?: string; // абсолютная ссылка на карточку рейса на авиабилетах
    routeStations?: IRouteStation[];
    codeshares?: ICodeshare[];
    isSupplement?: boolean;
    status?: {
        status: string;
        actualDt: string; // '2020-03-11T15:40:00+03:00' или '' - актуальное время события (прилета/вылета)
        actualTerminal: string; // 'B' или '' - актуальный терминал. Может отличаться от терминала по расписанию, и в этом случае нужно выводить сообщение
        checkInDesks: string; // '301-364' или '' - стойки регистрации, только для вылетов
        gate: string; // '119' или '' - номер выхода на посадку или высадку
        baggageCarousels: string; // '5' или '' - номер багажной карусели, только для прилетов
        diverted: IRouteStation; // присутствует только если рейс перенаправили в другой аэропорт, и содержит информацию об этом аэропорте
    };
}
