import ThreadStatus from './ThreadStatus';
import IRouteStation from './IRouteStation';
import DateMoment from '../../date/DateMoment';

export default interface IStationThreadStatus {
    status: ThreadStatus;

    actualDt?: DateMoment; // '2020-03-11T15:40:00+03:00' - актуальное время события (прилета/вылета)
    actualTerminalName?: string; // 'B' - актуальный терминал. Может отличаться от терминала по расписанию, и в этом случае нужно выводить сообщение
    checkInDesks?: string; // '301-364' - стойки регистрации, только для вылетов
    gate?: string; // '119' - номер выхода на посадку или высадку
    baggageCarousels?: string; // '5' - номер багажной карусели, только для прилетов
    diverted?: IRouteStation; // присутствует только если рейс перенаправили в другой аэропорт, и содержит информацию об этом аэропорте
}
