import IStationThreadEventDt from './IStationThreadEventDt';
import {TransportType} from '../../../lib/transportType';
import IRouteStation from './IRouteStation';
import ICodeshare from './ICodeshare';
import IStationThreadStatus from './IStationThreadStatus';

export default interface IThreadPlane {
    eventDt: IStationThreadEventDt;
    number: string;
    transportType: TransportType;
    canonicalUid: string;
    companyId: number; // id компании-перевозчика
    routeStations: IRouteStation[];
    isSupplement: boolean;

    terminalName?: string; // 'B' - название терминала по расписанию
    aviaLink?: string; // абсолютная ссылка на карточку рейса на авиабилетах
    codeshares?: ICodeshare[];
    status?: IStationThreadStatus;
    daysText?: string;
    hoursBeforeEvent?: number; // количество часов с текущего момента времени до отправления/приземления рейса
    minutesBetweenEventDtAndActualDt?: number; // количество минут между ожидаемым временем события и фактическим. Если ожидаемое время 8:20, а фактическое 8:00, то тут будет 20
}
