import IStops from './IStops';
import IStationThreadEventDt from './IStationThreadEventDt';
import DateMoment from '../../date/DateMoment';
import DateRobot from '../../date/DateRobot';
import ITransportSubtype from './ITransportSubtype';
import {TransportType} from '../../../lib/transportType';

export default interface IThreadRailroad {
    eventDt: IStationThreadEventDt;
    number: string;
    transportType: TransportType;
    canonicalUid: string;
    title: string; // 'Москва — Смоленск'

    isExpress?: boolean;
    isAeroExpress?: boolean;
    stops?: IStops;
    departure?: DateRobot;
    departureFrom?: DateMoment;
    transportSubtype?: ITransportSubtype;
    deluxeTrainTitle?: string;
    platform?: string;
    daysText?: string; // полная строка с днями хождения, может отсутствовать, если указаны runDaysText.
    runDaysText?: string; // строка дней, когда нитка точно ходит, имеет приоритет над daysText.
    exceptDaysText?: string; // строка исключения дней хождения. Работает вместе с runDaysText. Может отсутствовать, если нет исключаемых дней или используется daysText. Слово "кроме" в строку не включено.
}
