import IStationStatus from './IStationStatus';
import IMajority from './IMajority';
import {TransportType} from '../../../lib/transportType';
import IAeroexpress from './IAeroexpress';
import IStationType from './IStationType';

export default interface IStation {
    status: IStationStatus;
    majority: IMajority;
    t_type: TransportType;
    aeroexpress: IAeroexpress | null;
    is_metro: boolean;
    title: string;
    station_type: IStationType;
    id: number;
    popular_title: string; // Поле в ответе ручки есть всегда, если нет популярного тайтла, то используется просто title
    originalTitle: string;
    metrikaTarget: string;

    aeroexpressMetrikaTarget?: string;
}
