import IFactInfo from '../stateThread/factInfo/IFactInfo';
import IThreadSettlement from '../../IThreadSettlement';
import IStationCountry from './IStationCountry';
import StationSubtype from '../station/StationSubtype';
import StationType from '../station/StationType';

/* Не полный интерфейс */
export default interface IStation {
    factInfo: IFactInfo | null;
    isFuzzy: boolean;
    isNoStop: boolean;
    isCombined: boolean;
    url: string;
    country: IStationCountry;
    title: string;
    platform: string;
    isTechnicalStop: boolean;
    timezone: string;
    hidden: boolean;
    settlement: IThreadSettlement;
    id: number;
    transitionTime: number;
    arrivalLocalDt: string;
    departureLocalDt: string;
    capitalTimeOffset: string; // например "+00:00", может быть пустой строкой

    isStationFrom?: boolean;
    isStationTo?: boolean;
    mainSubtype?: StationSubtype;
    pageType?: StationType;
}
