import {Moment} from 'moment';

import ITransferFromApi from './ITransferFromApi';
import ITransferSegment from './ITransferSegment';
import ISegmentTariffs from '../segment/ISegmentTariffs';
import ISegmentTariffClass from '../segment/ISegmentTariffClass';
import ISegmentBadges from '../segment/ISegmentBadges';

export default interface ITransfer extends ITransferFromApi {
    segments: ITransferSegment[];
    segmentId: string;
    isDynamic: boolean; // Признак того, что это рейс-пополнение. Т.е. данный сегмент пришел с тарифами.
    isGone: boolean;
    timezoneFrom: string;
    timezoneTo: string;
    tariffClassKeys: string[]; // На этапе рендеринга здесь будут ключи тарифов, которые нужно отображать
    badges: ISegmentBadges;

    isOpened?: boolean; // Признак того, что пересадка раскрыта в интерфейсе (показан маршрут)
    queryingPrices?: boolean;
    tariffs?: ISegmentTariffs<ISegmentTariffClass>;
    departureMoment?: Moment; // Может быть доступно внутри некоторых компонентов, чьим родителем является common/components/SearchSegments/SearchSegments. Появляется при патчинге объекта в common/lib/segments/segmentRenderingData функцией getSegmentTimes из common/lib/segments/cachedSegmentTime
    arrivalMoment?: Moment; // Может быть доступно внутри некоторых компонентов, чьим родителем является common/components/SearchSegments/SearchSegments. Появляется при патчинге объекта в common/lib/segments/segmentRenderingData функцией getSegmentTimes из common/lib/segments/cachedSegmentTime
    departureRailwayMoment?: Moment | null; // Может быть доступно внутри некоторых компонентов, чьим родителем является common/components/SearchSegments/SearchSegments. Появляется при патчинге объекта в common/lib/segments/segmentRenderingData функцией getSegmentTimes из common/lib/segments/cachedSegmentTime
    arrivalRailwayMoment?: Moment | null; // Может быть доступно внутри некоторых компонентов, чьим родителем является common/components/SearchSegments/SearchSegments. Появляется при патчинге объекта в common/lib/segments/segmentRenderingData функцией getSegmentTimes из common/lib/segments/cachedSegmentTime
}
