import {Moment} from 'moment';

import ISegmentTariffs from '../segment/ISegmentTariffs';
import ISegmentTariffClass from '../segment/ISegmentTariffClass';
import ITransferSegmentFromApi from './ITransferSegmentFromApi';

export default interface ITransferSegment extends ITransferSegmentFromApi {
    tariffClassKeys: string[]; // На этапе рендеринга здесь будут ключи тарифов, которые нужно отображать
    isGone: boolean;
    timezoneFrom: string;
    timezoneTo: string;
    badges: undefined;

    tariffs?: ISegmentTariffs<ISegmentTariffClass>;
    queryingPrices?: boolean;
    departureMoment?: Moment; // Может быть доступно внутри некоторых компонентов, чьим родителем является common/components/SearchSegments/SearchSegments. Появляется при патчинге объекта в common/lib/segments/segmentRenderingData функцией getSegmentTimes из common/lib/segments/cachedSegmentTime
    arrivalMoment?: Moment; // Может быть доступно внутри некоторых компонентов, чьим родителем является common/components/SearchSegments/SearchSegments. Появляется при патчинге объекта в common/lib/segments/segmentRenderingData функцией getSegmentTimes из common/lib/segments/cachedSegmentTime
    departureRailwayMoment?: Moment | null; // Может быть доступно внутри некоторых компонентов, чьим родителем является common/components/SearchSegments/SearchSegments. Появляется при патчинге объекта в common/lib/segments/segmentRenderingData функцией getSegmentTimes из common/lib/segments/cachedSegmentTime
    arrivalRailwayMoment?: Moment | null; // Может быть доступно внутри некоторых компонентов, чьим родителем является common/components/SearchSegments/SearchSegments. Появляется при патчинге объекта в common/lib/segments/segmentRenderingData функцией getSegmentTimes из common/lib/segments/cachedSegmentTime
}
