import ISegmentThreadBase from '../segment/ISegmentThreadBase';
import ISegmentTransport from '../segment/ISegmentTransport';
import ITransferStation from './ITransferStation';
import ISegmentCompany from '../segment/ISegmentCompany';
import ISegmentTariffs from '../segment/ISegmentTariffs';
import ISegmentTariffClassFromBackend from '../segment/ISegmentTariffClassFromBackend';

export default interface ITransferSegmentFromBackend {
    id: string;
    arrival: string;
    departure: string;
    isThroughTrain: boolean;
    isInterval: boolean;
    price: null;
    provider: string;
    convenience: number;
    thread: ISegmentThreadBase;
    transport: ISegmentTransport;
    stationFrom: ITransferStation;
    stationTo: ITransferStation;
    company: ISegmentCompany;

    hasDynamicPricing?: boolean;
    tariffs?: ISegmentTariffs<ISegmentTariffClassFromBackend>;
    trainPurchaseNumbers?: string[]; // Для сегмента электричек ЦППК, которые являются одновременно и поездами, номера поездовых ниток.
    hasTrainTariffs?: boolean | null;
    salesLimitInDays?: number; // За сколько дней открывается продажа билетов на поезда. Бывает для поездов на выдаче на все дни.
}
