import ITransferStationSettlement from './ITransferStationSettlement';
import StationType from '../state/station/StationType';
import StationSubtype from '../state/station/StationSubtype';

export default interface ITransferStation {
    id: number;
    settlement: ITransferStationSettlement;
    countryId: number;
    title: string; // Москва (Казанский вокзал)
    popularTitle: string; // Казанский вокзал
    titleGenitive: string; // Москвы (Казанский вокзал)
    titleLocative: string; // Москве (Казанский вокзал)
    titleAccusative: string; // Москву (Казанский вокзал)
    railwayTimezone: string;
    timezone: string;
    preposition: string;

    pageType?: StationType; // 'train'. Возможно сейчас это поле есть всегда, но на момент добавления данного кода ручка /service/transfers-with-prices не возвращала эти данные
    mainSubtype?: StationSubtype; // 'train'. Возможно сейчас это поле есть всегда, но на момент добавления данного кода ручка /service/transfers-with-prices не возвращала эти данные
}
