// Связана с экспериментом RASPFRONT-6951

import updateQuery from './url/updateQuery';
import getQuery from './url/getQuery';

interface IGetBlablacarUtmFromDistance {
    orderUrl: string;

    distance?: number;
}

export const from25to50 = '2550';
export const from50to75 = '5075';

export function addBlablacarUtmFromDistance({
    orderUrl,
    distance,
}: IGetBlablacarUtmFromDistance): string {
    if (!orderUrl || distance === undefined) {
        return orderUrl;
    }

    const {comuto_cmkt = ''} = getQuery(orderUrl);
    const comutoParams =
        typeof comuto_cmkt === 'string' ? comuto_cmkt.split('_') : [];

    if (
        distance >= 25 &&
        distance < 50 &&
        comutoParams.indexOf(from25to50) === -1
    ) {
        comutoParams.push(from25to50);
    }

    if (
        distance >= 50 &&
        distance < 75 &&
        comutoParams.indexOf(from50to75) === -1
    ) {
        comutoParams.push(from50to75);
    }

    const updatedComuto = comutoParams.join('_');

    return comuto_cmkt !== updatedComuto
        ? updateQuery(orderUrl, {comuto_cmkt: updatedComuto})
        : orderUrl;
}
