import IApiLib from '../interfaces/api/IApiLib';
import IApi from '../interfaces/api/IApi';

// Обертка для типизации ручек апи
export default function apiWrapper(
    api: IApiLib,
): IApi & {exec: IApiLib['exec']} {
    const exec = api.exec.bind(api);

    const execStation: IApi['execStation'] = (params, req) =>
        exec('station', params, req);
    const execStationQuick: IApi['execStationQuick'] = (params, req) =>
        exec('stationQuick', params, req);
    const execStationPopularDirections: IApi['execStationPopularDirections'] = (
        params,
        req,
    ) => exec('stationPopularDirections', params, req);
    const execStationPopularDirections2: IApi['execStationPopularDirections2'] =
        (params, req) => exec('stationPopularDirections2', params, req);
    const execStationCityStations: IApi['execStationCityStations'] = (
        params,
        req,
    ) => exec('stationCityStations', params, req);
    const execStationStops: IApi['execStationStops'] = (params, req) =>
        exec('stationStops', params, req);
    const execTransfersWithPrices: IApi['execTransfersWithPrices'] = (
        params,
        req,
    ) => exec('transfersWithPrices', params, req);
    const execSearchTransfer2: IApi['execSearchTransfer2'] = (params, req) =>
        exec('searchTransfer2', params, req);
    const execSeoMetaInfo: IApi['execSeoMetaInfo'] = (params, req) =>
        exec('seoMetaInfo', params, req);
    const execBlablacarCityLink: IApi['execBlablacarCityLink'] = (
        params,
        req,
    ) => exec('blablacarCityLink', params, req);
    const execDirections: IApi['execDirections'] = (params, req) =>
        exec('directions', params, req);
    const execPopularDirections: IApi['execPopularDirections'] = (
        params,
        req,
    ) => exec('popularDirections', params, req);
    const execStations: IApi['execStations'] = (params, req) =>
        exec('stations', params, req);
    const execTeasers: IApi['execTeasers'] = (params, req) =>
        exec('teasers', params, req);
    const execBusTariffs: IApi['execBusTariffs'] = (params, req) =>
        exec('busTariffs', params, req);
    const execBusTariffs2: IApi['execBusTariffs2'] = (params, req) =>
        exec('busTariffs2', params, req);
    const execBugReport: IApi['execBugReport'] = (params, req) =>
        exec('bugReport', params, req);
    const execStaticPage: IApi['execStaticPage'] = (params, req) =>
        exec('staticPage', params, req);
    const execSearch: IApi['execSearch'] = (params, req) =>
        exec('search', params, req);
    const execTimeCorrection: IApi['execTimeCorrection'] = (params, req) =>
        exec('timeCorrection', params, req);
    const execParseContext: IApi['execParseContext'] = (params, req) =>
        exec('parseContext', params, req);
    const execCanonicals: IApi['execCanonicals'] = (params, req) =>
        exec('canonicals', params, req);
    const execSampleSearchContext: IApi['execSampleSearchContext'] = (
        params,
        req,
    ) => exec('sampleSearchContext', params, req);
    const execTrainTariffs2: IApi['execTrainTariffs2'] = (params, req) =>
        exec('trainTariffs2', params, req);
    const execAllDaysTariffs: IApi['execAllDaysTariffs'] = (params, req) =>
        exec('allDaysTariffs', params, req);
    const execThread2: IApi['execThread2'] = (params, req) =>
        exec('thread2', params, req);

    return {
        exec,
        execStation,
        execStationQuick,
        execStationPopularDirections,
        execStationPopularDirections2,
        execStationCityStations,
        execStationStops,
        execTransfersWithPrices,
        execSearchTransfer2,
        execSeoMetaInfo,
        execBlablacarCityLink,
        execDirections,
        execPopularDirections,
        execStations,
        execTeasers,
        execBusTariffs,
        execBusTariffs2,
        execBugReport,
        execStaticPage,
        execSearch,
        execTimeCorrection,
        execParseContext,
        execCanonicals,
        execSampleSearchContext,
        execTrainTariffs2,
        execAllDaysTariffs,
        execThread2,
    };
}
