type TypeOfArray<T> = {[K in keyof T]: T[K] extends any[] ? T[K][0] : never};

export default function cartesianProduct<T extends any[][]>(
    ...arrays: T
): TypeOfArray<T>[] {
    return arrays.reduce(
        (result, arrayOfParam) => {
            const copyResult = result.slice();

            const arraysWithResult = arrayOfParam.map(param => {
                return copyResult.map(array => {
                    const copyArray = array.slice();

                    copyArray.push(param);

                    return copyArray;
                });
            });

            return ([] as any[]).concat(...arraysWithResult);
        },
        [[]],
    );
}
