// Типы CURRENT и OTHER используются в случае, если мы используем упрощенную схему представления различных расписаний
export const CURRENT = 'current';
export const OTHER = 'other';

// Типы BASIC, CHANGE, CANCEL и ASSIGNMENT используются для разделения расписаний
// на основные, изменения, отменённые и назначенные
export const BASIC = 'basic';
export const BASIC_CURRENT = 'basic-current';
export const BASIC_OTHER = 'basic-other';
export const CHANGE = 'change';
export const CHANGE_CURRENT = 'change-current';
export const CHANGE_OTHER = 'change-other';
export const CANCEL = 'cancel';
export const ASSIGNMENT = 'assignment';

// Специальный тип для расписаний, не входящих в контекст нитки
export const NON_CONTEXT = 'non-context';

export const ORDER_BASIC_CURRENT = [
    BASIC_CURRENT,
    BASIC_OTHER,
    CANCEL,
    CHANGE,
    NON_CONTEXT,
];
export const ORDER_CHANGE_CURRENT = [
    CHANGE_CURRENT,
    CHANGE_OTHER,
    CANCEL,
    BASIC,
    NON_CONTEXT,
];
export const ORDER = [CURRENT, OTHER, NON_CONTEXT];
