import {InterruptError} from './errors/executionErrors';
import compareSearchContexts from './compareSearchContexts';

export default function createSearchContextChecker(getState) {
    const oldContext = getState().search.context;

    return value => {
        const newContext = getState().search.context;

        if (compareSearchContexts(oldContext, newContext)) {
            return Promise.resolve(value);
        }

        return Promise.reject(new InterruptError());
    };
}
