import GetState from '../interfaces/actions/GetState';
import EnvironmentType from '../interfaces/EnvironmentType';

import {InterruptError} from './errors/executionErrors';

export default function createUrlChecker(
    getState: GetState,
): (value?: any) => Promise<any> {
    const {
        page: {fullUrl},
        environment,
    } = getState();

    const isServerSide = environment.type === EnvironmentType.server;

    return (value): Promise<typeof value> =>
        isServerSide || fullUrl === getState().page.fullUrl
            ? Promise.resolve(value)
            : Promise.reject(new InterruptError('page is obsolete'));
}
