export default function convertPrice(price, currencies) {
    const originalCurrency = price.currency;

    const {nationalCurrency, preferredCurrency, currencyRates} = currencies;

    if (preferredCurrency === originalCurrency) {
        return price;
    }

    let rate;

    if (
        currencyRates[originalCurrency] &&
        currencyRates[originalCurrency][preferredCurrency]
    ) {
        rate = 1 / currencyRates[originalCurrency][preferredCurrency];
    } else if (
        currencyRates[preferredCurrency] &&
        currencyRates[preferredCurrency][originalCurrency]
    ) {
        rate = currencyRates[preferredCurrency][originalCurrency];
    } else if (
        currencyRates[nationalCurrency] &&
        currencyRates[nationalCurrency][preferredCurrency] &&
        currencyRates[nationalCurrency][originalCurrency]
    ) {
        rate =
            currencyRates[nationalCurrency][preferredCurrency] /
            currencyRates[nationalCurrency][originalCurrency];
    }

    if (rate) {
        return {
            value: rate * price.value,
            currency: preferredCurrency,
        };
    }

    return price;
}
