import {momentTimezone as moment} from '../../../reexports';

import {SPECIAL_VALUES, WEEKDAY_NAMES} from './values';
import {HUMAN, HUMAN_SHORT, ROBOT} from './formats';

import {updateTime} from './update';
import {updateSpecialTime} from './updateByType';
import {complete} from '../stringUtils';

export function buildSpecial(
    special,
    {time, language, text = undefined, hint = undefined, forceFormat = false},
) {
    const formatted = SPECIAL_VALUES[language][special];

    if (text && hint && !forceFormat) {
        hint = complete(text, hint);
    } else {
        hint = text = formatted;
    }

    return updateSpecialTime(
        {
            text,
            hint,
            special,
            formatted,
        },
        time,
    );
}

export function buildWeekday(
    weekday,
    {time, language, text = undefined, hint = undefined, forceFormat = false},
) {
    const formatted = WEEKDAY_NAMES[language][weekday];

    if (text && hint && !forceFormat) {
        hint = complete(text, hint);
    } else {
        hint = text = formatted;
    }

    return updateTime(
        {
            text,
            hint,
            weekday,
            formatted,
        },
        time,
    );
}

export function buildDate(
    date,
    {language, text = undefined, hint = undefined, forceFormat = false},
) {
    const dateAsMoment = moment(date, ROBOT);

    dateAsMoment.locale(language);
    const formatted = dateAsMoment.format(HUMAN).toLowerCase();
    const shortFormatted = dateAsMoment.format(HUMAN_SHORT).toLowerCase();

    if (text && hint && !forceFormat) {
        hint = complete(text, hint);
    } else {
        text = hint = formatted;
    }

    return {
        text,
        hint,
        date,
        formatted,
        shortFormatted,
    };
}

export function buildFromObject({date, special, weekday}, params) {
    if (date) {
        return buildDate(date, params);
    }

    if (special) {
        return buildSpecial(special, params);
    }

    if (typeof weekday !== 'undefined') {
        return buildWeekday(Number(weekday), params);
    }

    return null;
}
