import moment from 'moment';

import {EDurationShortening} from '../../interfaces/date/EDurationShortening';

export const SECONDS = 'seconds';
export const MINUTES = 'minutes';
export const HOURS = 'hours';
export const DAYS = 'days';
export const WEEKS = 'weeks';

export const TIME_UNITS_LIST = [SECONDS, MINUTES, HOURS, DAYS, WEEKS];
export const TIME_UNITS_LENGTHS = TIME_UNITS_LIST.reduce(
    (result, unit) => ({
        ...result,
        [unit]: moment.duration(1, unit).asMilliseconds(),
    }),
    {},
);

export const DEFAULT_DURATION_ROUNDING_OPTIONS = {
    shortestUnit: MINUTES,
    longestUnit: WEEKS,
    maxUnits: 2,
    maxGaps: 0,
};

export const DEFAULT_DURATION_FORMAT_OPTIONS = {
    ...DEFAULT_DURATION_ROUNDING_OPTIONS,
    short: EDurationShortening.AUTO,
};
