import moment from 'moment';

import {
    TIME_UNITS_LIST,
    TIME_UNITS_LENGTHS,
    DEFAULT_DURATION_ROUNDING_OPTIONS,
} from './constants';

export function roundDuration(duration, options) {
    const {shortestUnit, longestUnit, maxGaps, maxUnits} = {
        ...DEFAULT_DURATION_ROUNDING_OPTIONS,
        ...options,
    };

    let unit;
    let gapsLeft = maxGaps;
    let unitsLeft = maxUnits;
    let index = TIME_UNITS_LIST.indexOf(longestUnit);
    const lastIndex = TIME_UNITS_LIST.indexOf(shortestUnit);

    let firstUnitFound = false;
    let rest = duration.asMilliseconds();

    if (rest <= 0) {
        return moment.duration();
    }

    while (rest > 0 && gapsLeft >= 0 && unitsLeft > 0 && index >= lastIndex) {
        unit = TIME_UNITS_LIST[index];
        const unitLength = TIME_UNITS_LENGTHS[unit];
        const unitCount = Math.floor(rest / unitLength);

        firstUnitFound = firstUnitFound || unitCount > 0;

        if (firstUnitFound) {
            if (unitCount > 0) {
                unitsLeft--;
                rest -= unitLength * unitCount;
            } else {
                gapsLeft--;
            }
        }

        index--;
    }

    return moment.duration(Math.round(duration.as(unit)), unit);
}
