import {Moment} from 'moment';

// Возвращает объект moment с ближайшей датой после текущего момента времени
// dateStr - строка с днем месяца вида "12", "7"
export default function getClosestMoment(
    dateStr: string,
    today: Moment,
    canAddDigit: boolean,
): Moment | undefined {
    let date = parseInt(dateStr, 10);

    if (date > 31 || (date < 0 && !canAddDigit) || date < 1) {
        return;
    }

    const result = today.clone();
    const todayDate = today.date();
    const daysInCurrentMonth = today.daysInMonth();

    // Если в текущий месяц результат не вписывается, то точно впишется в следующий (это потому что месяца в которых 31 день как минимум чередуются)
    if (date > daysInCurrentMonth) {
        result.add(1, 'month').date(date);

        return result;
    }

    if (date < todayDate) {
        const dateWithZero = date * 10;

        if (
            canAddDigit &&
            dateWithZero <= daysInCurrentMonth &&
            dateWithZero + 9 >= todayDate
        ) {
            date = Math.max(todayDate, dateWithZero);
        } else {
            result.add(1, 'month');

            if (date > result.daysInMonth()) {
                result.add(1, 'month');
            }
        }
    }

    result.date(date);

    return result;
}
