import {isWhitespace} from '../stringUtils';
import {getToday} from './utils';
import {ROBOT} from './formats';
import {getLanguagePriority} from './values';
import {buildDate} from './build';
import {parseDate, parseSpecial, parseWeekday} from './parseImpl';

export default function parse(text, {time, tld, language}, forceFormat) {
    if (isWhitespace(text)) {
        if (forceFormat) {
            return buildDate(getToday(time).format(ROBOT), {
                time,
                language,
                forceFormat,
            });
        }

        return {text};
    }

    const languages = getLanguagePriority(tld, language);

    for (const currentLanguage of languages) {
        const params = [text, time, language, currentLanguage, forceFormat];

        const result =
            parseDate(...params) ||
            parseSpecial(...params) ||
            parseWeekday(...params);

        if (result) {
            return result;
        }
    }

    return {text};
}
