import {ROBOT, HUMAN} from './formats';
import {
    SPECIAL_VALUES_PRIORITY,
    SPECIAL_VALUES,
    WEEKDAY_NAMES,
    WEEKDAY_NAMES_SHORT,
} from './values';

import {startsWith} from '../stringUtils';
import {getToday} from './utils';
import {buildSpecial, buildWeekday, buildDate} from './build';
import parseDateToMoment from './parseDate';

export function parseSpecial(
    text,
    time,
    language,
    currentLanguage,
    forceFormat,
) {
    for (const special of SPECIAL_VALUES_PRIORITY) {
        const hint = SPECIAL_VALUES[currentLanguage][special];

        if (startsWith(hint, text)) {
            return buildSpecial(special, {
                text,
                hint,
                time,
                language,
                forceFormat,
            });
        }
    }
}

export function parseWeekday(
    text,
    time,
    language,
    currentLanguage,
    forceFormat,
) {
    const todayWeekday = getToday(time).weekday();
    let weekday = todayWeekday;

    do {
        let hint = WEEKDAY_NAMES[currentLanguage][weekday];

        if (startsWith(hint, text)) {
            return buildWeekday(weekday, {
                text,
                hint,
                time,
                language,
                forceFormat,
            });
        }

        hint = WEEKDAY_NAMES_SHORT[currentLanguage][weekday];

        if (startsWith(hint, text)) {
            return buildWeekday(weekday, {
                text,
                hint,
                time,
                language,
                forceFormat,
            });
        }

        weekday = (weekday + 1) % 7;
    } while (weekday !== todayWeekday);
}

export function parseDate(text, time, language, currentLanguage, forceFormat) {
    const parsed = parseDateToMoment(text, getToday(time), currentLanguage);

    if (!parsed) {
        return;
    }

    const disableHint = /[-./]/.test(text);

    const hint = disableHint
        ? text
        : parsed.locale(currentLanguage).format(HUMAN).toLowerCase();

    return buildDate(parsed.format(ROBOT), {
        text,
        hint,
        language,
        forceFormat,
    });
}
