import {momentTimezone as moment} from '../../../reexports';

import {ROBOT} from './formats';
import {getToday, fitInRange, getClosestWeekday, getRange} from './utils';
import {SPECIAL_VALUES_OFFSETS} from './values';

export function updateSpecialTime(value, time) {
    const offset = SPECIAL_VALUES_OFFSETS[value.special];

    if (offset) {
        return {
            ...value,
            date: getToday(time).clone().add(offset).format(ROBOT),
        };
    }

    return value;
}

export function updateDateTime(value, time) {
    const date = moment.tz(value.date, ROBOT, time.timezone);
    const range = getRange(getToday(time));

    return {
        ...value,
        date: fitInRange(date, range).format(ROBOT),
    };
}

export function updateWeekdayTime(value, time) {
    const date = getToday(time);

    return {
        ...value,
        date: getClosestWeekday(value.weekday, date).format(ROBOT),
    };
}
