import {IElementRect} from '../../interfaces/lib/dimensions/IElementRect';

export default function getElementRect(element: Element | null): IElementRect {
    if (!element) {
        throw new Error(
            'Элемент переданный в функцию getElementRect не определён',
        );
    }

    const clientRect = element.getBoundingClientRect();
    const left = clientRect.left + window.pageXOffset;
    const top = clientRect.top + window.pageYOffset;
    const {width, height} = clientRect;

    return {
        width,
        height,
        left,
        top,
        right: left + width,
        bottom: top + height,
    };
}
